#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=9
#SBATCH --job-name=IN1k-LP
#SBATCH --time=96:00:00
#SBATCH --mem=120G
#SBATCH --constraint=v100|rtx6k|rtx8k|p40|v100s
#SBATCH --exclude=gnodee8,gnodec1



EXP_STR="mocov2/balanced_user-BS256-LR0.03-EP200-temp-0.2"

EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
MODEL_STR=${EXPERIMENT_PATH}/checkpoint.pth.tar
EXPERIMENT_PATH+='/warmup_BN'
mkdir -p $EXPERIMENT_PATH
echo "will use" ${MODEL_STR}

/scratch/shared/beegfs/yuki/envs/py37/bin/python3 warmup_BN.py \
            -a resnet50 \
            --lr 30.0 \
            --batch-size 32 \
            --pretrained ${MODEL_STR} \
            --dump_path ${EXPERIMENT_PATH} \
            " " 2>&1 | tee -a ${EXPERIMENT_PATH}/log.txt
